
#ifndef _OIMGLTEX_H
#define _OIMGLTEX_H

#ifdef __AFX_H__
	#ifdef OIMGLT_DLL
		#define OCIMG_API __declspec(dllexport)
	#else
		#define OCIMG_API __declspec(dllimport)
	#endif
	#define TreeNode		OCXmlWrapperBase
	#define StringArray		CScriptMocaObject
	#define	IntArray		CScriptMocaObject
	extern "C" {
#else
	#define OCIMG_API
	#pragma dll(OImgLT)	// Associate all functions below to OImgLT.dll which must be in the Origin EXE folder
	#define	IntArray	vector<int>
#endif	//__AFX_H__

#define OCIMG_CALL WINAPI
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////

// The following functions are wrappers to LEADTools functions.
/**$
	Parameters:
		pbmh = [input] pointer to the LEAD bitmap to separate.
		flags = [input] see COLORSEP_* in ocImgLT.h.
		pbmh0 = [modify] pointer of the LEAD bitmap of one channel.
		pbmh1 = [modify] pointer of the LEAD bitmap of one channel.
		pbmh2 = [modify] pointer of the LEAD bitmap of one channel.
		pbmh3 = [modify] pointer of the LEAD bitmap of one channel.
		
	Example1:
		#include <ocImgLT.h>
		#include <oImgLTex.h>
		#include <image_utils.h>
		void ol_color_separate_bitmap_ex()
		{
			
			string strFile = GetOriginPath() + "samples\\Image Processing and Analysis\\Flower.jpg";
			if( !strFile.IsFile() )
			{
				out_str("Import file not existed");
				return;
			}	
			
		    pBITMAPHANDLE pLBmpSrc = image_import(strFile);
			if( pLBmpSrc )
			{
				// perpare source image matrix
				MatrixPage mpSource;
				mpSource.Create("origin");
				mpSource.Rename("Source1");
				MatrixLayer mlSource = mpSource.Layers();
				MatrixObject moSource = mlSource.MatrixObjects();
			    moSource.SetLeadBitmap(pLBmpSrc, false, true);
				
			    // separete
				pBITMAPHANDLE pbhR, pbhG, pbhB;
				pbhR = ol_new_bitmap();
				pbhG = ol_new_bitmap();
				pbhB = ol_new_bitmap();
			
				int nRet = ol_color_separate_bitmap(pLBmpSrc, COLORSEP_RGB, pbhB, pbhG, pbhR);
				if( SUCCESS == nRet )
				{
					MatrixPage mpRed, mpGreen, mpBlue;
					mpRed.Create("origin");				
					mpGreen.Create("origin");
					mpBlue.Create("origin");
					
					mpRed.Rename("Red1");
					mpGreen.Rename("Green1");
					mpBlue.Rename("Blue1");
					
					MatrixLayer mlRed, mlGreen, mlBlue;
					mlRed = mpRed.Layers();
					mlGreen = mpGreen.Layers();
					mlBlue = mpBlue.Layers();
					
					MatrixObject moRed, moGreen, moBlue;
					moRed = mlRed.MatrixObjects();
					moGreen = mlGreen.MatrixObjects();
					moBlue = mlBlue.MatrixObjects();			
					
					// bMakeCopy, flag to indicate if a copy of the LEAD bitmap should be set into the matrix object.
					// if true, need to call ol_delete_bitmap to delete pbhR, pbhG and pbhB here, else no need.
					bool bMakeCopy = false; 			
					bool bResetZoom = true;
					moRed.SetLeadBitmap(pbhR, bMakeCopy, bResetZoom);
					moGreen.SetLeadBitmap(pbhG, bMakeCopy, bResetZoom);
					moBlue.SetLeadBitmap(pbhB, bMakeCopy, bResetZoom);				
				}
			}	
		}
	Return:
		returns SUCCESS for success.
	SeeAlso:
		ol_color_merge_bitmap
*/
OCIMG_API int OCIMG_CALL ol_color_separate_bitmap(pBITMAPHANDLE pbmh, L_UINT32 flags, pBITMAPHANDLE pbmh0, pBITMAPHANDLE pbmh1, pBITMAPHANDLE pbmh2, pBITMAPHANDLE pbmh3=NULL);

/**$
	Parameters:
		pbmh = [modify] pointer to the LEAD bitmap after merge.
		flags = [input] see COLORSEP_* in ocImgLT.h.
		pbmh0 = [input] pointer of the LEAD bitmap of one channel.
		pbmh1 = [input] pointer of the LEAD bitmap of one channel.
		pbmh2 = [input] pointer of the LEAD bitmap of one channel.
		pbmh3 = [input] pointer of the LEAD bitmap of one channel.
		
	Example1:
		#include <ocImgLT.h>
		#include <oImgLTex.h>
		#include <image_utils.h>
		void ol_color_merge_bitmap_ex()
		{
			MatrixPage mpRed("Red1"), mpGreen("Green1"), mpBlue("Blue1");
			if( !mpRed || !mpGreen || !mpBlue )
				return;
			
			MatrixLayer mlRed, mlGreen, mlBlue;
			mlRed = mpRed.Layers();
			mlGreen = mpGreen.Layers();
			mlBlue = mpBlue.Layers();
			
			MatrixObject moRed, moGreen, moBlue;
			moRed = mlRed.MatrixObjects();
			moGreen = mlGreen.MatrixObjects();
			moBlue = mlBlue.MatrixObjects();			
			
			pBITMAPHANDLE pbhR, pbhG, pbhB;
			pbhR = (pBITMAPHANDLE)moRed.GetLeadBitmap();
			pbhG = (pBITMAPHANDLE)moGreen.GetLeadBitmap();
			pbhB = (pBITMAPHANDLE)moBlue.GetLeadBitmap();
			
			pBITMAPHANDLE pbhResult;
			pbhResult = ol_new_bitmap();
			
			int nRet = ol_color_merge_bitmap(pbhResult, COLORSEP_RGB, pbhB, pbhG, pbhR);
			if( SUCCESS == nRet )
			{
				MatrixPage mpResult;
				mpResult.Create("origin");
				mpResult.Rename("Result1");
				
				MatrixLayer mlResult = mpResult.Layers();
				MatrixObject moResult = mlResult.MatrixObjects();
			    moResult.SetLeadBitmap(pbhResult, false, true);
			}
		}	
	Return:
		returns SUCCESS for success.
	SeeAlso:
		ol_color_separate_bitmap
*/
OCIMG_API int OCIMG_CALL ol_color_merge_bitmap(pBITMAPHANDLE pbmh, L_UINT32 flags, pBITMAPHANDLE pbmh0, pBITMAPHANDLE pbmh1, pBITMAPHANDLE pbmh2, pBITMAPHANDLE pbmh3=NULL);

OCIMG_API int OCIMG_CALL ol_dlg_file_open(HWND hWnd, LPSTR lpszFile, DWORD dwBufSize, LPCSTR lpcszFilter, LPCSTR lpcszPath, int* lpnDefType, LPCSTR lpcszTitle, BOOL bMultiSel = FALSE);

/**$
*/
OCIMG_API int OCIMG_CALL ol_create_bitmap_from_matrix(pBITMAPHANDLE pbmh, USHORT* pData, UINT nDataWidth, UINT nDataHeight);
OCIMG_API int OCIMG_CALL ol_create_bitmap_from_byte_matrix(pBITMAPHANDLE pbmh, LPBYTE pData, UINT nDataWidth, UINT nDataHeight);

/**$
*/
OCIMG_API int OCIMG_CALL ol_set_matrix_from_bitmap(USHORT* pData, pBITMAPHANDLE pbmh);
OCIMG_API int OCIMG_CALL ol_set_byte_matrix_from_bitmap(LPBYTE pData, pBITMAPHANDLE pbmh);

OCIMG_API pBITMAPHANDLE ol_new_bitmap(int nWidth = 0, int nHeight = 0, int nBitsPerPixel = 16);

/// EJP 2009-07-14 QA80-13532 NEED_OL_DELETE_BITMAP_FOR_OL_NEW_BITMAP
OCIMG_API void ol_delete_bitmap(pBITMAPHANDLE pbmh);
/// end NEED_OL_DELETE_BITMAP_FOR_OL_NEW_BITMAP

/**$
   for fft wrap in vc ---sandy---2009.9.14
*/
//OCIMG_API int OCIMG_CALL ol_allocFTArray(pBITMAPHANDLE pbmh, pFTARRAY  *pFTArray);
//OCIMG_API int OCIMG_CALL ol_fft(pBITMAPHANDLE pbmh, pFTARRAY  pFTArray, L_UINT uFlags);
//OCIMG_API int OCIMG_CALL ol_fft_all_in_one(pBITMAPHANDLE pbmh, L_UINT uFlags);
OCIMG_API int OCIMG_CALL ol_LineProfile(pBITMAPHANDLE pBitmapHndl,	
								POINT* pFirstPoint,
								POINT* pSecondPoint,
								L_INT L_FAR * L_FAR * pRed,
								L_INT L_FAR * L_FAR * pGreen,
								L_INT L_FAR * L_FAR * pBlue);
//   ----end sandy

OCIMG_API int OCIMG_CALL ol_test_imadjust();


#ifdef __AFX_H__
	}
#endif	//__AFX_H__

#endif // !_OIMGLTEX_H


